--The scripts should always contain at least 10 functions :ScriptID, DisplaySourceName(), SourceSuperClassID(), SourceClassID(), DisplayDestinationName() DestinationSuperClassID(), DestinationClassID(), AboutText() and DefaultConversion, Conversion taking a param.
--Script ID that will append to destination
fn ScriptID = 
(
	""
)

--Return the name to be display for the source in the Scene Converter UI
fn DisplaySourceName =
(
	"mental ray Arch and Design"
)

--Returns the source class of the super class id 
fn SourceSuperClassID =
(
	3072 --Material
)
--Returns the class id of the source class we use as a source for conversion
fn SourceClassID =
(
	#(0x70b05735L, 0x4a163654L) --Arch and Design Material
)

--Return the name to be display for the destination in the Scene Converter UI
fn DisplayDestinationName =
(
	"Architectural Material"
)

--Returns the destination class of the super class id
fn DestinationSuperClassID =
(
	3072 --Material
)
--Returns the class id of the class we use as a destination for conversion
-- so we convert from SourceClassID() to DestinationClassID()
fn DestinationClassID =
(
	#(0x13d11bbeL, 0x691e3037L)--Architectural Material
)

--Validate that the source provided match with one of the SourceClass
fn VerifySource source =
(
	local ret = false	
	local src = SourceClassID()
	
	if(source == undefined) do return false
	
	if(classof src[1] == Array) then
    (
		for cd in src do
		(
			if((cd as string) == (source.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((src as string) == (source.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)
--Validate that the destination provided match with one of the DestinationClass
fn VerifyDestination destination =
(
	local ret = false	
	local dest = DestinationClassID()

	if(destination == undefined) do return false
	
	if(classof dest[1] == Array) then
    (
		for cd in dest do
		(
			if((cd as string) == (destination.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((dest as string) == (destination.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)

--Returns some information about this conversion script
--Should this be localized ?
fn AboutText =
(
	"Converts from a mental ray Arch and Design material to an Architectural material"
)

--Internal function that does the parameter mapping
fn ConvertFrom_ArchAndDesignToArchitectural Source Dest =
(
	if ( false == VerifySource Source or 
		 false == VerifyDestination Dest
		) do
	(
		--Not the suitable nodes
		return undefined
	)
	
	Dest
)

--This function is use as entry when the source is missing (due to a missing plugin) and cannot be completly loaded. 
--In that case the default parameters are loaded.
fn DefaultConversion source /*not use*/ =
(
	--Create the dest material
	newMat = Architectural()

	--Return the new material
	newMat
)

--Main entry point from this script
--This function handles the material's creation
fn Conversion archandDesignMat =
(
	if (false == VerifySource archandDesignMat )  do
	(
		--Not the suitable node
		return undefined
	)
	
	
	--Create the dest material
	newMat = Architectural()
	
	--Call the parameters mapping function to convert
	ConvertFrom_ArchAndDesignToArchitectural archandDesignMat newMat
	
	if (IsProperty archandDesignMat "name") and (undefined != archandDesignMat.name) and (String == classof archandDesignMat.name) do
	(
		newMat.name = archandDesignMat.name
	)

	--return the new material
	newMat
)
